﻿using System;
using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class FragLabOrder : BasePage
{
    LabOrderManager _manager = new LabOrderManager();
    WKF_CASE_ACTIVITY _activity;

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabOrders.aspx",
        "/PatientWorkflows.aspx"
    };

    public FragLabOrder()
    {
        //Manager Save Notification Event Handler
        _manager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            int orderId;
            if (int.TryParse(Request.QueryString["activityId"], out orderId))
            {
                getRefreshLabOrder(orderId);
                ViewState["ReferralCaseId"] = _activity.WKF_CASE.REFERRAL_ID;
                //only for biological
                if (_activity.STD_WKFACTIVITYTYPE_ID == 3)
                    SetupFragLabOrder();
            }

            SetReferringPage();
        }

        RangeValidatorLabRequestDateIsDate.MaximumValue =
        RangeValidatorLabelSampleReceivedDateIsDate.MaximumValue = DateTime.Today.ToShortDateString();
    }

    private void getRefreshLabOrder(int oId)
    {
        _activity = _manager.getLabOrderByOrderID(oId);
        _activity.SetAsChangeTrackingRoot();
    }

    private void SetupFragLabOrder()
    {
        lblSampleType.Text = "FRAGMENT";

        if (_activity.LAB_ORDERs.Count > 0)
        {
            LAB_ORDER order = _activity.LAB_ORDERs.First();

            var shortDate = order.LAB_SEND_DATE.HasValue ? order.LAB_SEND_DATE.Value.ToString("yy") : DateTime.Today.ToString("yy");
            lblLabRequestNumber.Text = shortDate + " - " + "TEF" + order.LAB_ORDER_ID.ToString().PadLeft(5, '0');

            if (order.LAB_SEND_DATE.HasValue)
            {
                LabRequestDate.Text = order.LAB_SEND_DATE.Value.ToShortDateString();
                //LabRequestDate.DateValue = order.LAB_SEND_DATE.Value.ToShortDateString();
            }
            else
            {
                if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Voided)
                {
                    LabRequestDate.Text = String.Empty;
                }
                else
                {
                    LabRequestDate.Text = DateTime.Now.ToShortDateString();
                }
            }
            if (order.LAB_RECEIVED_DATE.HasValue)
            {
                LabSampleReceivedDate.Text = order.LAB_RECEIVED_DATE.Value.ToShortDateString();
                //SampleReceivedDate.DateValue = order.LabReceivedDate.Value.ToShortDateString();
            }
            if (order.LAB_RETURN_DATE.HasValue)
            {
                LabelLabReportDate.Text = order.LAB_RETURN_DATE.Value.ToShortDateString();
            }
        }
        else
        {
            LabRequestDate.Text = DateTime.Today.ToString("d");

        }

        switch (_activity.STD_WKFACTIVITYSTS_ID)
        {
            case (int)WorkflowCaseActivityStatus.New:
                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                SaveButton.Enabled = false;
                CompleteButton.Enabled = true;
                VoidButton.Enabled = true;
                SaveButton.Text = "Save";

                RequiredFieldValidatorLabRequestDate.Enabled = true;

                SaveButton.ValidationGroup = "";

                break;

            case (int)WorkflowCaseActivityStatus.AwaitingResults:
                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                SaveButton.Enabled = true;
                CompleteButton.Enabled = false;
                VoidButton.Enabled = false;
                SaveButton.Text = "Save";

                RequiredFieldValidatorLabRequestDate.Enabled = true;

                SaveButton.ValidationGroup = "LabOrderValidation";

                break;

            case (int)WorkflowCaseActivityStatus.Closed:
                CompleteButton.Enabled = false;
                SaveButton.Enabled = false;
                VoidButton.Enabled = false;
                LabelForLabLabelReportDate.Visible = true;
                LabelLabReportDate.Visible = true;
                SaveButton.Text = "Save";
                RequiredFieldValidatorLabRequestDate.Enabled = true;

                SaveButton.ValidationGroup = "";

                break;

            //void status
            case (int)WorkflowCaseActivityStatus.Voided:
                SaveButton.Enabled = true;
                CompleteButton.Enabled = false;
                VoidButton.Enabled = false;
                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                SaveButton.Text = "Un-Void";
                RequiredFieldValidatorLabRequestDate.Enabled = false;

                SaveButton.ValidationGroup = "LabOrderValidation";

                break;

        }

    }

    private void SaveCompleteLabOrder(Func<string> operation)
    {
        LAB_ORDER order;

        if (_activity.LAB_ORDERs.Count > 0)
        {

            order = _activity.LAB_ORDERs.First();

            SaveLabOrder(ref order);

        }
        else
        {
            order = new LAB_ORDER();

            SaveLabOrder(ref order);

            order.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;
            _activity.LAB_ORDERs.Add(order);
        }
        //set questionnaire in-process status

        OpenCloseReferralAndWorkflowCase(operation);

        _manager.Update(_activity);
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        FormViewBreadCrumb.DataBind();
        getRefreshLabOrder(_activity.WKF_CASE_ACTIVITY_ID);

    }

    //this is the function that gets all values from page controls to eventually save them in a database  
    private void SaveLabOrder(ref LAB_ORDER labOrder)
    {

        labOrder.LAB_SEND_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRequestDate.Text.Trim());
        //labOrder.LAB_SEND_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRequestDate.DateValue.Trim());
        labOrder.LAB_RECEIVED_DATE = Helpers.ConvertStringToNullable<DateTime>(LabSampleReceivedDate.Text.Trim());
        //labOrder.LabReceivedDate = Helpers.ConvertStringToNullable<DateTime>(SampleReceivedDate.DateValue.Trim());
        labOrder.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabelLabReportDate.Text.Trim());


        //EFR registry
        labOrder.STD_REGISTRY_ID = 1;
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string activityXml = (string)ViewState["activityXml"];
        _activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activityXml);

    }

    protected override object SaveViewState()
    {
        ViewState["activityXml"] = _activity.Serialize();
        return base.SaveViewState();

    }

    protected void SaveButton_Click(object sender, EventArgs e)
    {
        if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Voided)
        {
            _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.New;
        }

        SaveCompleteLabOrder(() => "Save");
        SetupFragLabOrder();
    }

    protected void CancelButton_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    protected void CompleteButton_Click(object sender, EventArgs e)
    {
        //_activity.STD_WKFACTIVITYSTS_ID = 2;
        _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.AwaitingResults;

        bool labResultExists = _manager.ActivityExists(_activity.WKF_CASE_ID, WorkFlowActivityTypes.LabResult);

        if (!labResultExists)
        {

            WKF_CASE_ACTIVITY NewActivity = new WKF_CASE_ACTIVITY();
            //NewActivity.WKF_CASE_ID = Activity.WKF_CASE_ID;
            NewActivity.WKF_CASE_ID = _activity.WKF_CASE_ID;
            NewActivity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(WorkFlowActivityTypes.LabResult);
            NewActivity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.New);
            NewActivity.REPRESENTATIVE_NAME = _activity.REPRESENTATIVE_NAME;
            NewActivity.CONTACT_NAME = _activity.CONTACT_NAME;
            //NewActivity.WKF_CASE.WKF_CASE_ACTIVITies.Add(NewActivity);
            NewActivity.SetAsChangeTrackingRoot(EntityState.New, true);
            NewActivity.SetAsInsertOnSubmit();

            _manager.Update(NewActivity);
        }

        SaveCompleteLabOrder(() => "Complete");

        SetupFragLabOrder();
    }

    protected void VoidButton_Click(object sender, EventArgs e)
    {

        LabRequestDate.Text = "";
        LabSampleReceivedDate.Text = "";

        _activity.STD_WKFACTIVITYSTS_ID = 3;

        SaveCompleteLabOrder(() => "Void");

        SetupFragLabOrder();

    }

    private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();
        //WorkflowManager wfm = new WorkflowManager();
        int wfCaseRefId;
        if (int.TryParse(ViewState["ReferralCaseId"].ToString(), out wfCaseRefId))
        {
            EFR_REFERRAL parentReferral = rm.getReferralByReferralID(wfCaseRefId);


            parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
            parentReferral.SetAsChangeTrackingRoot();

            WKF_CASE parentCase = parentReferral.WKF_CASEs.Where(a => a.WKF_CASE_ID == _activity.WKF_CASE_ID).First();

            if (operation() == "Void")
            {
                //close workflow case
                parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
                var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

                //if (parentReferral.WKF_CASEs.Where(a => a.WKF_CASE_ID != activity.WKF_CASE_ID
                //   && a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed).Count() == 0)
                //if all cases are closed close referral as well
                if (items.Where(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed).Count() == 0)

                    parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
            }
            else
            {
                if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                    parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;


                if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                    parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;

            }

            SuppressSaveSuccessMessage = true;
            rm.Update(parentReferral);

            SuppressSaveSuccessMessage = false;
        }
    }


    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR_LABORDER";
    }

    public override string AppObjectCode()
    {

        return "EFR_LABORDER";
    }
}
